close all;
clear;
clc;

load("Efficiency.mat");
load("Shaft_torque.mat");
load("Speed.mat");

Speed_max = Speed(:,1);
Torque_max = Shaft_Torque(:,1);

F = scatteredInterpolant(Speed(:),Shaft_Torque(:),Efficiency(:));

% levels plot
figure
levels = [0:0.70:0.70 00.70:0.1:0.94 0.94:0.01:1]*100;
M = contourf(Speed,Shaft_Torque,Efficiency,levels);
hold on
plot(Speed_max,Torque_max)
grid on 
title('EM efficiency map')
xlabel('EM speed [rpm]')
ylabel('Shaft Torque [Nm]')

Efficiency(Efficiency==0) = 1;

% surface plot
figure
%surf([Speed(:,1:27) Speed(:,32:end)],[Shaft_Torque(:,1:27) Shaft_Torque(:,32:end)], [Efficiency(:,1:27) Efficiency(:,32:end)])
surf(Speed,Shaft_Torque,Efficiency)
title('EM efficiency surface')
xlabel('EM speed [rpm]')
ylabel('Shaft Torque [Nm]')
zlabel('Efficiency [%]')




